#include"UruchamianieAplikacji.h"

CCreateProcess::CCreateProcess()
{
	fileName.Empty();
	priority = prNormal;
	directory.Empty();
	left = 0;
	top = 0;
	width = 800;
	height = 600;
	defaultPosition = true;
	defaultSize = true;
	windowStyle = swNormal;
	memset(&processInformation,0,sizeof(PROCESS_INFORMATION));
}

bool CCreateProcess::Execute()
{
	if (fileName.IsEmpty()) return false;

	//Inicjowanie struktury zawierajacej parametry uruchomienia aplikacji
	STARTUPINFO startupInfo;
	memset(&startupInfo,0,sizeof(STARTUPINFO));
	startupInfo.cb=sizeof(STARTUPINFO);
	startupInfo.lpDesktop=NULL; //desktop z aplikacji, ktora uruchamia
	startupInfo.lpTitle=NULL; //tytul okna konsoli, jezeli taka jest tworzona
	startupInfo.dwX=left;
	startupInfo.dwY=top;
	startupInfo.dwXSize=width;
	startupInfo.dwYSize=height;

	int flags=STARTF_USESHOWWINDOW;
	if (!defaultPosition) flags=(flags | STARTF_USEPOSITION);
	if (!defaultSize) flags=(flags | STARTF_USESIZE);
	startupInfo.dwFlags=flags;
	startupInfo.wShowWindow=windowStyle;

	//Tworzenie i zerowanie struktury do ktorej zapisane beda informacje o procesie
	PROCESS_INFORMATION lProcessInformation;
	memset(&lProcessInformation,0,sizeof(PROCESS_INFORMATION));

	LPWSTR lFileName = fileName.GetBuffer();
	LPCWSTR lDirectory ;
	if(directory.IsEmpty())
		lDirectory = NULL;
	else
		lDirectory = directory;

	//Uruchamianie procesu
	bool Wynik=CreateProcess(
							NULL, //plik exe aplikacji
							lFileName,//polecenie uruchamiajace program
							NULL, //korzystamy z domyslnego opisu bezpieczenstwa procesu
							NULL, //korzystamy z domyslnego opisu bezpieczenstwa watku
							false, //czy uchwyty dziedziczone w procesie
							priority, //priorytet
							NULL, //korzystanie ze zmiennych srodowiska aplikacji wywolujacej
							lDirectory,//directory, //katalog biezacy aplikacji
							&startupInfo, //parametry uruchomienia aplikacji
							&lProcessInformation //informacje o uruchomionej aplikacji
							);
	processInformation=lProcessInformation;
	return Wynik;

}

bool CCreateProcess::ExecuteAndWait()
{
	bool wynik = Execute();

	if(!wynik) return false;

	WaitForSingleObject(processInformation.hProcess,INFINITE);

	memset(&processInformation,0,sizeof(PROCESS_INFORMATION));

	return wynik;
}